define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('VarUtilityAuthorizationService', function ($http, $q, $rootScope, localResourceDirectoryService) {
		var _authorizationService = {};
		var isAuthorized = false;

		_authorizationService.isAuthorized = function () {
			return isAuthorized;
		};

		_authorizationService.checkAuthorizedKey = function () {
			var deferred = $q.defer();

			localResourceDirectoryService.fetch().then(function(directory) {
				$http.get(directory['rest-v1']).then(function(response) {
					isAuthorized = (response.status === 200 || response.status === 404);
					deferred.resolve(isAuthorized);
				});
			});

			return deferred.promise;
		};

		return _authorizationService;
	});
});